VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_SAP"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Declare Sub Sleep Lib "Kernel32" (ByVal dwMiliseconds As Long)

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const SCREEN_NAME As String = "DPC_SAP"
Private Const SW_SHOWNORMAL = 1

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const LOCALE_USER_DEFAULT = &H400
Private Const C_ERRORRAISE As Long = 2500
Private Const C_MSG_ID_BASE As Long = 9700

Private Const ROWIDTRANSTATUS_NEW = "NEW"
Private Const ROWIDTRANSTATUS_OK = "OK"
Private Const ROWIDTRANSTATUS_ERROR = "ERROR"

' FTP settings
Private Const FTP_PASIVE As Boolean = True

Private mb_Initialized              As Boolean

Dim mb_copyAbort As Boolean         ' Global flag for file transfer operation
Dim ms_copyFile As String           ' Actualy transfering file
Dim mb_runCancel As Boolean         ' Global flag
Dim ms_FTPRoot As String            ' root directory for opened FTP session

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum

#If LIVE = 1 Then
Private mo_FSO As Object
Private mo_Db As Object
Private mo_DbAMC As Object
Private mo_Shell As Object
#Else
Private mo_FSO As Scripting.FileSystemObject
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_DbAMC As ARMSYSCOMLib.ArmDb
Private mo_Shell As Object
#End If

Private mo_Tools As DPC_Tools

Private ml_U_Code As Long
Private ms_Language_Code As String
Private ValidityDate As Date
Private ms_AMCServer As String
Private ms_AMCDatabase As String
Private ms_AMCLoginName As String
Private ms_AMCPassword As String
Private ml_AMCFi_Nr As Long
Private ms_AMCSource As String

Private mta_XmlSql() As TXmlSql

Private Type TXmlSql
  Request As String
  Cursor As Long
  ATS_Id As Long
  ATS_Type As eDPCXmlSqlType
  ATS_Node As String
  ATS_IsSubNode As Boolean
  ATS_IsMaster As Boolean
  ATS_ParentId As Long
  ATS_ImportName As String
  ATS_Profile As String
  ATS_Version As Long
End Type

'logging variables ... required to call mo_tools.LogRequest
Public ILO_Interface As eDPCXmlExportType
Public ILO_MasterId As String
Public ILO_Status As Integer
Public ILO_RespMsg As String
Public ILO_Error As String
Public ILO_Connection As String
Public ILO_XMLSent As String
Public ILO_DateSent As Date
Public ILO_XMLResponse As String
Public ILO_Performance As Double

' remarks - need DB user to write export tables and read all other
' when the result is ready ? which status to check ?
' how to send the same article to secretbox again ?
' is it possible to update article ?
' Link BOM to agpos fuer material abbuchung
' definier ag bennenung (nr:benennng)
' abw_plus = 500%

Public Property Set ArmDb(ByVal ao_Db As Object)
On Error GoTo ErrHandler
  
  Set mo_Db = ao_Db
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Property Get ArmDbAMC() As Object
On Error GoTo ErrHandler
  
  Set ArmDbAMC = mo_DbAMC
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDbAMC.Get")
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Property Let U_Code(al_Code As Long)
On Error GoTo ErrHandler
  
  ml_U_Code = al_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("U_Code.Let")
End Property

Property Let Language_Code(as_Language_Code As String)
On Error GoTo ErrHandler
  
  ms_Language_Code = as_Language_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("Language_Code.Let")
End Property


Public Function Load_A_COM()
On Error GoTo ErrorHandler

Dim ls_TempDir As String

  If mb_Initialized Then Exit Function
  
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  Set mo_FSO = CreateObject("Scripting.FileSystemObject")
  Set mo_Shell = CreateObject("WSCript.Shell")
  If mo_Shell Is Nothing Then
      Call Err.Raise(666, "CreateObject()", "Cannot create WSCript.Shell.")
  End If

  ls_TempDir = mo_Tools.GetAndCreateTempDir(mo_FSO, SCREEN_NAME)
   
#If ENV = LIVE Then
    Set mo_DbAMC = CreateObject("ArmSysCOM.ArmDb")
#Else
    Set mo_DbAMC = New ARMSYSCOMLib.ArmDb
#End If
    
  'ms_Server = "Martin-NB\SQL2008"
  'ms_Database = "test70"
  'ms_User = "sa"
  'ms_Password = "sedma1972"
  
  ms_AMCServer = "10.68.16.40\LIVE_SAGE"
  ms_AMCDatabase = "test70"
  ms_AMCLoginName = "test70"
  ms_AMCPassword = "erp"
  
  ms_AMCSource = "Capture"
  ml_AMCFi_Nr = 1
  If ms_Language_Code = "" Then ms_Language_Code = "E"
  
  mb_Initialized = True
  Load_A_COM = True
  Exit Function
ErrorHandler:
  Call ErrorHandler("Load_A_Com")
End Function

Public Function Unload_A_COM() As Boolean
On Error GoTo ErrorHandler

  If Not mb_Initialized Then Exit Function
  Call mo_Tools.DeleteTemporaryFolder(mo_FSO, SCREEN_NAME)
  
  'Set mo_Tools.ArmDb = Nothing
  
  ''Call mo_DbBaeurer.Disconnect
  Set mo_FSO = Nothing
  Set mo_Db = Nothing
  Set mo_Tools = Nothing
  Set mo_DbAMC = Nothing
  
  mb_Initialized = False
  
  Unload_A_COM = True
  Exit Function
ErrorHandler:
  Call ErrorHandler("Unload_A_Com")
End Function

Public Function SaveXMLDocument(ByVal ao_XML As Object, ByVal as_FileName As String, ByVal as_ATI_Name As String, Optional ab_OnlyValidate = True, Optional ab_OnlySave = False) As String
On Error GoTo ErrorHandler

Dim lo_shell As Object
Dim ls_XmlPath As String
Dim lo_XmlIndentedDocument As MSXML2.DOMDocument
Dim lo_XmlIndenter As MSXML2.DOMDocument
Dim ls_ValidationXSD As String
Dim ls_FormatterXML As String

  Set lo_shell = CreateObject("WSCript.Shell")
  If lo_shell Is Nothing Then
      Call Err.Raise(666, "CreateObject()", "Cannot create WSCript.Shell.")
  End If
  
  Set lo_XmlIndentedDocument = CreateObject("MSXML2.DOMDocument")
  Set lo_XmlIndenter = CreateObject("MSXML2.DOMDocument")

  lo_XmlIndenter.async = False
  
  Call LoadXMLFiles(as_ATI_Name, ls_ValidationXSD, ls_FormatterXML)
  
  Call lo_XmlIndenter.Load(ls_FormatterXML)

  Call ao_XML.transformNodeToObject(lo_XmlIndenter, lo_XmlIndentedDocument)
  
  If ab_OnlyValidate = False Then
    ls_XmlPath = App.Path & "\" & as_FileName & ".xml"
    Call lo_XmlIndentedDocument.Save(ls_XmlPath)
    Call lo_shell.Run("""" & ls_XmlPath & """")
  End If
  
  If ab_OnlySave = False Then
    Call ValidateXMLFile(lo_XmlIndentedDocument.xml, "", ls_ValidationXSD, True)
  End If
    
  SaveXMLDocument = lo_XmlIndentedDocument.xml
  
  Set lo_shell = Nothing
  Exit Function
ErrorHandler:
  Call ErrorHandler("SaveXMLDocument")
End Function

Public Function LoadXMLFiles(ByVal as_ATI_Name As String, ByRef as_SchemaFile As String, ByRef as_FormatterFile As String) As Boolean
On Error GoTo ErrHandler

Dim ls_path As String
Dim lc_Cursor As Long
Dim ls_Request As String
Dim ls_Schema As String
Dim ls_SchemaName As String
Dim ls_Formatter As String
Dim ls_FormatterName As String

  LoadXMLFiles = False
  
  ls_Request = "SELECT ATI_Schema,ATI_SchemaName, ATI_Formatter,ATI_FormatterName FROM DPC_AttribInterface WHERE ATI_Name = $ATI_Name$"
  
  ls_Request = Replace(ls_Request, "$ATI_Name$", mo_Tools.SQLStr(as_ATI_Name), , , vbTextCompare)
  
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ls_Schema = mo_Db.GetFields(lc_Cursor, "ATI_Schema")
    ls_SchemaName = mo_Db.GetFields(lc_Cursor, "ATI_SchemaName")
    ls_Formatter = mo_Db.GetFields(lc_Cursor, "ATI_Formatter")
    ls_FormatterName = mo_Db.GetFields(lc_Cursor, "ATI_FormatterName")
  Else
    Err.Raise ArmErr.InvalidArgument, "as_ATI_Name", "Invalid ATI_Name: " & as_ATI_Name
  End If
  
  Call mo_Db.Close(lc_Cursor)
  
  ls_path = App.Path & "\Download\XMLSchema\"
    
  If Not mo_FSO.FolderExists(ls_path) Then
    Call mo_FSO.CreateFolder(ls_path)
  End If
  
  as_SchemaFile = ls_path & ls_SchemaName
  
  If Not mo_FSO.FileExists(as_SchemaFile) Then
    If Not mo_Db.BlobToFileSQL("SELECT F_Data_File FROM A_Files WHERE F_File_Key='" & ls_Schema & "'", as_SchemaFile, True, False) Then
      Err.Raise ArmErr.CompFncFailed, "BlobToFileSQL", "File download failed A_File_Key:" & ls_Schema & "," & mo_Db.LastErrorMessage
      Exit Function
    End If
  End If
    
  If Len(ls_FormatterName) > 0 Then
    as_FormatterFile = ls_path & ls_FormatterName
    
    If Not mo_FSO.FileExists(as_FormatterFile) Then
      If Not mo_Db.BlobToFileSQL("SELECT F_Data_File FROM A_Files WHERE F_File_Key='" & ls_Formatter & "'", as_FormatterFile, True, False) Then
        Err.Raise ArmErr.CompFncFailed, "BlobToFileSQL", "File download failed A_File_Key:" & ls_Formatter & "," & mo_Db.LastErrorMessage
        Exit Function
      End If
    End If
  End If
  
  LoadXMLFiles = True
  
  Exit Function
  
ErrHandler:
  
  If lc_Cursor <> 0 Then
      Call mo_Db.Close(lc_Cursor)
  End If

  LoadXMLFiles = False
  Call ErrorHandler("LoadXMLFiles")
End Function

Function ValidateXMLFile(ByVal ls_strXmlFile As String, ls_strUrn As String, ls_strXsdFile As String, Optional ab_ParseString = False) As Boolean
On Error GoTo ErrorHandler
Dim ls_Desc As String
    
   'Create an XML DOMDocument object.
   Dim lo_Schema As Object
   Dim lo_XMLDoc As Object
    
   ValidateXMLFile = False
   
   Set lo_Schema = CreateObject("MSXML2.XMLSchemaCache.4.0")
   Call lo_Schema.Add(ls_strUrn, ls_strXsdFile)

   ' Create an XML DOMDocument object.
   Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument.4.0")

   ' Assign the schema cache to the DOM document.
   ' schemas collection.
   Set lo_XMLDoc.schemas = lo_Schema

   lo_XMLDoc.async = False
   
   If ab_ParseString = False Then
        lo_XMLDoc.Load ls_strXmlFile
   Else
        lo_XMLDoc.loadXML ls_strXmlFile
   End If

   ' Return validation results in message to the user.
   If lo_XMLDoc.parseError.errorCode <> 0 Then
        
        If ab_ParseString = False Then
            ls_Desc = "Validation failed on " & ls_strXmlFile & vbCrLf
        Else
            ls_Desc = "Validation failed" & vbCrLf
        End If
        
        ls_Desc = ls_Desc & "Reason: " & lo_XMLDoc.parseError.reason & _
             vbCrLf & "Source: " & _
             lo_XMLDoc.parseError.srcText & _
             vbCrLf & "Line: " & _
             lo_XMLDoc.parseError.line & vbCrLf
             
             Err.Raise ArmErr.CompFncFailed, "ValidateXMLFile", ls_Desc
             
    Else
        ValidateXMLFile = True
    End If
    
    Set lo_Schema = Nothing
    Set lo_XMLDoc = Nothing
    
    Exit Function
ErrorHandler:
  
    Set lo_Schema = Nothing
    Set lo_XMLDoc = Nothing
  
  Call ErrorHandler("ValidateXMLFile")
End Function

Private Function CreateXMLNode(ByVal as_Name As String, ByVal ac_CursorXML As Long, ByVal av_Value As Variant, ByVal ao_XMLDoc As Object, ByVal ao_parentNode As Object)
On Error GoTo ErrorHandler

Dim ls_DataType As String
Dim ll_DataLength As Long
Dim ll_DataPrecision As Long
Dim ls_Name As String
Dim ll_Idx As Long
Dim ls_value As String
Dim ls_Default As String
Dim ls_CodeLookup As String
Dim ls_AtrName As String

  If mo_Db.Find(ac_CursorXML, "ATR_Name", as_Name, 0, 1) < 0 Then
       Err.Raise ArmErr.SQLBadRowExpectedCount, "Distinct", "No SQL Data for XML export found. ATR_B7Name missing:" + as_Name
       Exit Function
  End If

  ls_AtrName = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_Name"))
  ls_Default = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DefaultValue"))
  ls_value = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_Value"))
  ls_DataType = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataType"))
  ll_DataLength = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataLength"))
  ll_DataPrecision = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataPrecision"))
  ls_CodeLookup = Trim(mo_Db.GetFields(ac_CursorXML, "AC_CodeLookup"))
  
  If Left(ls_Default, 1) = "'" And right(ls_Default, 1) = "'" Then
    ls_Default = Mid(ls_Default, 2, Len(ls_Default) - 2)
  End If
  
  If ls_value = "" Then
    ls_value = ls_Default
  Else
    If ls_CodeLookup = "" Then
      ls_value = FormatXML(av_Value, ls_DataType, ll_DataPrecision)
    Else
      ls_value = ConvertCodeToAMC(ls_CodeLookup, av_Value)
      ls_value = FormatXML(ls_value, ls_DataType, ll_DataPrecision)
    End If
  End If
  
  If Len(ls_value) > ll_DataLength Then
    ls_value = Left(ls_value, ll_DataLength)
  End If
  
  Call AppendElement(ao_XMLDoc, ao_parentNode, mo_Db.GetFields(ac_CursorXML, "ATR_B7Name"), ls_value)
  Exit Function
ErrorHandler:
  Call ErrorHandler("CreateXMLNode ATR_Name=" & ls_AtrName)
End Function

Private Function FormatXML(ByVal av_Data As Variant, ByVal as_DataType As String, ByVal al_DataPrecision As Long)
On Error GoTo ErrorHandler

  FormatXML = ""
  Select Case UCase(as_DataType)
  Case "N"
    If al_DataPrecision = 0 Then
      FormatXML = FormatXMLInt(Val(av_Data))
    Else
      FormatXML = FormatXMLFloat(av_Data, 2)
    End If
  Case "D"
    FormatXML = FormatXMLDateTime(av_Data)
  Case Else
    FormatXML = CStr(av_Data)
  End Select
  Exit Function
ErrorHandler:
  Call ErrorHandler("FormatXML")
End Function

Private Function GetXmlCursor(ByVal ae_ATR_Type As eDPCXmlExportType) As Long
On Error GoTo ErrorHandler

Dim ls_Request As String

  ls_Request = "exec DPC_AttribXML_SAP_lst $ATR_Type$"
  ls_Request = Replace(ls_Request, "$ATR_Type$", mo_Tools.SqlInt(ae_ATR_Type), , , vbTextCompare)
  GetXmlCursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  Exit Function
ErrorHandler:
  Call ErrorHandler("GetXmlCursor")
End Function


Private Function GetXmlSql(ByVal al_ATS_Id As Long) As TXmlSql
On Error GoTo ErrorHandler

Dim ll_Idx As Long
  
  For ll_Idx = 0 To UBound(mta_XmlSql)
    If al_ATS_Id = mta_XmlSql(ll_Idx).ATS_Id Then
      GetXmlSql = mta_XmlSql(ll_Idx)
      Exit Function
    End If
  Next
  Exit Function
ErrorHandler:
  Call ErrorHandler("GetXmlSql")
End Function

Private Function GetXmlMasterSql() As TXmlSql
On Error GoTo ErrorHandler

Dim ll_Idx As Long
  
  For ll_Idx = 0 To UBound(mta_XmlSql)
    If mta_XmlSql(ll_Idx).ATS_IsMaster Then
      GetXmlMasterSql = mta_XmlSql(ll_Idx)
      Exit Function
    End If
  Next
  Exit Function
ErrorHandler:
  Call ErrorHandler("GetXmlMasterSql")
End Function

Private Function FormatXMLDateTime(ByVal ad_Value As Date) As String
On Error GoTo ErrorHandler
  
  If ad_Value = 0 Then
    FormatXMLDateTime = ""
  Else
    FormatXMLDateTime = Format(ad_Value, "yyyymmdd")
  End If
  Exit Function
ErrorHandler:
  Call ErrorHandler("FormatXMLDateTime")
End Function

Private Function FormatXMLFloat(ByVal ad_Value As Double, ByVal al_Precision As Long) As String
On Error GoTo ErrorHandler

  If al_Precision = 0 Then
    FormatXMLFloat = Format(Round(ad_Value, al_Precision), "0")
  Else
    FormatXMLFloat = Replace(Format(Round(ad_Value, al_Precision), "0." & String(al_Precision, "0")), ",", ".", , , vbTextCompare)
  End If
  Exit Function
ErrorHandler:
  Call ErrorHandler("FormatXMLFloat")
End Function

Private Function FormatXMLInt(ByVal al_Value As Long) As String
On Error GoTo ErrorHandler
  
  FormatXMLInt = CStr(al_Value)
  Exit Function
ErrorHandler:
  Call ErrorHandler("FormatXMLInt")
End Function

Private Function AppendElement(ByRef ao_Document As MSXML2.DOMDocument, ByRef ao_parentNode As MSXML2.IXMLDOMNode, ByVal as_Name As String, ByVal as_Value As String) As MSXML2.IXMLDOMNode
On Error GoTo ErrorHandler
    
   Set AppendElement = Nothing
    
#If LIVE = 1 Then
    Dim lo_newNode As Object
#Else
    Dim lo_newNode As MSXML2.IXMLDOMElement
#End If
    Set lo_newNode = ao_Document.createElement(as_Name)
    
    lo_newNode.Text = as_Value
    If ao_parentNode Is Nothing Then
      Set AppendElement = ao_Document.appendChild(lo_newNode)
    Else
      Set AppendElement = ao_parentNode.appendChild(lo_newNode)
    End If
    Exit Function
ErrorHandler:
    Call ErrorHandler("AppendElement")
End Function

Private Function CreateXMLPath(ByVal as_ExportName As String, ByVal as_key As String) As String
On Error GoTo ErrorHandler
Dim ls_path As String

  ls_path = mo_Tools.GetAndCreateTempDir(mo_FSO, SCREEN_NAME)
  as_key = Replace(as_key, "\", "_", , , vbTextCompare)
  as_key = Replace(as_key, "/", "_", , , vbTextCompare)
  as_key = Replace(as_key, "$", "_", , , vbTextCompare)
  as_key = Replace(as_key, "*", "_", , , vbTextCompare)
  
  CreateXMLPath = ls_path & "\" & as_ExportName & as_key & ".XML"
  Exit Function
ErrorHandler:
  Call ErrorHandler("CreateXMLPath")
End Function

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

  as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  ReplaceCommonPlaceholders = as_Request
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceCommonPlaceholders")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

Public Function ConvertCodeFromAMC(ByVal as_CodeConversion As String, ByVal as_CodeOut As String) As String
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_Request As String

  ConvertCodeFromAMC = ""
  ls_Request = "SELECT AC_CodeIn "
  ls_Request = ls_Request & "FROM A_CodeTranslator "
  ls_Request = ls_Request & "WHERE "
  ls_Request = ls_Request & "AC_CodeLookup = $AC_CodeLookup$ AND "
  ls_Request = ls_Request & "AC_CodeOut = $AC_CodeOut$"
    
  ls_Request = Replace(ls_Request, "$AC_CodeLookup$", mo_Tools.SQLStr(as_CodeConversion), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$AC_CodeOut$", mo_Tools.SQLStr(as_CodeOut), , , vbTextCompare)
  
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ConvertCodeFromAMC = mo_Db.GetFields(lc_Cursor, "AC_CodeIn")
  Else
    Err.Raise ArmErr.InvalidArgument, "as_CodeIn", "Invalid conversion code as_CodeConversion: " & as_CodeConversion & " as_CodeOut: " & as_CodeOut
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call mo_Db.Close(lc_Cursor)
  Call ErrorHandler("ConvertCodeFromAMC")
End Function

Public Function ConvertCodeToAMC(ByVal as_CodeConversion As String, ByVal as_CodeIn As String) As String
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_Request As String

  ConvertCodeToAMC = ""
  ls_Request = "SELECT AC_CodeOut "
  ls_Request = ls_Request & "FROM A_CodeTranslator "
  ls_Request = ls_Request & "WHERE "
  ls_Request = ls_Request & "AC_CodeLookup = $AC_CodeLookup$ AND "
  ls_Request = ls_Request & "AC_CodeIn = $AC_CodeIn$"
  
  ls_Request = Replace(ls_Request, "$AC_CodeLookup$", mo_Tools.SQLStr(as_CodeConversion), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$AC_CodeIn$", mo_Tools.SQLStr(as_CodeIn), , , vbTextCompare)
  
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ConvertCodeToAMC = mo_Db.GetFields(lc_Cursor, "AC_CodeOut")
  Else
    Err.Raise ArmErr.InvalidArgument, "as_CodeIn", "Invalid conversion code as_CodeConversion: " & as_CodeConversion & " as_CodeIn: " & as_CodeIn
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call mo_Db.Close(lc_Cursor)
  Call ErrorHandler("ConvertCodeToAMC")
End Function

Public Function GetATRValue(ByVal al_CursorXML As Long, ByVal al_CursorMaster As Long, ByVal al_ATR_Name As String) As Variant
On Error GoTo ErrHandler

Dim ls_value As String
Dim ls_place As String

  GetATRValue = ""
  
  If mo_Db.Find(al_CursorXML, "ATR_Name", al_ATR_Name, 0, 1) < 0 Then
       Err.Raise ArmErr.SQLBadRowExpectedCount, "Distinct", "No SQL Data for XML export found. ATR_B7Name missing:" + al_ATR_Name
  Else
    ls_place = mo_Db.GetFields(al_CursorXML, "ATR_Value")
    If InStr(ls_place, "$") > 0 Then
        GetATRValue = mo_Db.GetFields(al_CursorMaster, Replace(ls_place, "$", ""))
    Else
        GetATRValue = ls_place
    End If
  End If
    
  Exit Function
ErrHandler:
  Call ErrorHandler("GetATRValue")
End Function

Public Function SplitATRValue(ByVal as_Value As String, ByVal al_DataLength As Long) As String()
On Error GoTo ErrHandler

Dim la_StrValues() As String
Dim ll_Dimension As Integer
Dim ll_Index As Integer
Dim ll_Pos As Integer

    SplitATRValue = la_StrValues
    
    ReDim la_StrValues(0)
    ll_Index = 0

    If Len(as_Value) > al_DataLength Then
      While Len(as_Value) > al_DataLength
      
          ReDim Preserve la_StrValues(UBound(la_StrValues) + 1)
          ll_Pos = InStrRev(as_Value, vbCrLf, al_DataLength)
          If ll_Pos <= 0 Then
              ll_Pos = InStrRev(as_Value, " ", al_DataLength)
              If ll_Pos > 0 Then
                ll_Pos = ll_Pos - 1
              End If
          End If
          If ll_Pos > 0 Then
              la_StrValues(ll_Index) = Left(as_Value, ll_Pos)
              ll_Index = ll_Index + 1
              as_Value = right(as_Value, Len(as_Value) - (ll_Pos + 1))
          Else
              la_StrValues(ll_Index) = Left(as_Value, al_DataLength)
              ll_Index = ll_Index + 1
              as_Value = right(as_Value, Len(as_Value) - al_DataLength)
          End If
      Wend
      If Len(as_Value) > 0 Then
          la_StrValues(ll_Index) = as_Value
      Else
          ReDim Preserve la_StrValues(UBound(la_StrValues) - 1)
      End If
    Else
      ReDim la_StrValues(0)
      la_StrValues(0) = as_Value
    End If
    
    SplitATRValue = la_StrValues
    
  Exit Function
ErrHandler:
  Call ErrorHandler("SplitATRValue")
End Function

Public Function MaterialCreate(ByVal as_COF_Id As String, ByVal as_OFD_Id As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrorHandler

Dim ls_Xml As String
Dim ls_Response As String

        MaterialCreate = False
        
        ls_Xml = MaterialCreateGetXML(as_COF_Id, as_OFD_Id)
        If (SendRequest(DPC_SAP_MATERIAL_CREATE, "POST", ls_Xml, ls_Response) = True) Then
            
            'ls_Response = "<?xml version=""1.0"" encoding=""UTF-8""?><AMC_BASIC_SAP_BAPI_RESPONSE><SUCC_FAIL_IND>F</SUCC_FAIL_IND><ERRORS><ERROR_GROUP>" & _
            '    "<SEVERITY_TYPE>E</SEVERITY_TYPE><MSG_CLASS>SAP_WRAPPER_FM</MSG_CLASS><MSG_NO>999</MSG_NO><MSG_TEXT>Material already exists and changes are not permitted</MSG_TEXT>" & _
            '    "<MSG_PARM_ROW>0</MSG_PARM_ROW></ERROR_GROUP></ERRORS></AMC_BASIC_SAP_BAPI_RESPONSE>"
            
            If (ProcessBasicResponse(ls_Response, as_ErrorMsg) = True) Then
                MaterialCreate = True
            End If
            
            Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
        Else
            as_ErrorMsg = ls_Response
        End If
        
  Exit Function
ErrorHandler:
  
  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
  
  Call ErrorHandler("MaterialCreate")
End Function


Public Function MaterialCreateGetXML(ByVal as_COF_Id As String, ByVal as_OFD_Id As String) As String
On Error GoTo ErrorHandler

Dim lo_XmlDocCust As Object
Dim lo_SubNode As Object
Dim lo_ParentNode As Object
Dim lo_MainNode As Object
Dim lc_CursorMaster As Long
Dim lc_Header As Long
Dim lc_CursorXML As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ls_Request As String
Dim ls_ATR_Value As String
Dim ls_ATR_DataLength As Long
Dim la_StrValues() As String
Dim ll_Nominator As Long, ll_Denominator As Long
Dim ll_Index As Integer
Dim ls_UOM As String, ll_OFD_PU As Long
Dim ls_OFD_CurrCode, ls_RequiredCurrCode As String
Dim ld_ExRate, ld_Cost As Double

  Call mo_Tools.ClearLogInterface(Me)
  ILO_Interface = eDPCXmlExportType.etAMC_MaterialCreate
  
  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  
  lc_CursorXML = GetXmlCursor(eDPCXmlExportType.etAMC_MaterialCreate)
    
  Set lo_MainNode = lo_XMLDoc.createProcessingInstruction("xml", "version='1.0' encoding='utf-8'")
  lo_XMLDoc.appendChild lo_MainNode
    
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "AMC_MATERIAL_ICTP_CREATE", "")
  lo_MainNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
      
  ls_Request = "exec DPC_SAPMaterialCreateHeader_sel $COF_Id$,$OFD_Id$,$Language_Code$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Id$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$Language_Code$", "'E'", , , vbTextCompare)
  lc_Header = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  
  Call CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "MATERIAL_NO"), lo_XMLDoc, lo_MainNode)
  
  ILO_MasterId = GetATRValue(lc_CursorXML, lc_Header, "MATERIAL_NO")
  
  ls_UOM = GetATRValue(lc_CursorXML, lc_Header, "BASE_UOM")
  If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
    Call CreateXMLNode("BASE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "BASE_UOM_PCS"), lo_XMLDoc, lo_MainNode)
  Else
    Call CreateXMLNode("BASE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "BASE_UOM"), lo_XMLDoc, lo_MainNode)
  End If
  Call CreateXMLNode("NET_WEIGHT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "NET_WEIGHT"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("WEIGHT_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "WEIGHT_UOM"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("SALES_ORG_CUST_ORD", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SALES_ORG_CUST_ORD"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("DIST_CHAN_CUST_ORD", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DIST_CHAN_CUST_ORD"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("SALES_ORG_MANUF_LOC", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SALES_ORG_MANUF_LOC"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("DIST_CHAN_MANUF_LOC", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DIST_CHAN_MANUF_LOC"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("DEL_PLANT_CUST_ORD", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DEL_PLANT_CUST_ORD"), lo_XMLDoc, lo_MainNode)
  If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
    Call CreateXMLNode("TRIANG_SO_ICTP_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_AMT_PCS"), lo_XMLDoc, lo_MainNode)
  Else
    Call CreateXMLNode("TRIANG_SO_ICTP_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_AMT"), lo_XMLDoc, lo_MainNode)
  End If
  Call CreateXMLNode("TRIANG_SO_ICTP_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_CURR"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("TRIANG_SO_ICTP_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_UNIT"), lo_XMLDoc, lo_MainNode)
  If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
    Call CreateXMLNode("TRIANG_SO_ICTP_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_UOM_PCS"), lo_XMLDoc, lo_MainNode)
  Else
    Call CreateXMLNode("TRIANG_SO_ICTP_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_UOM"), lo_XMLDoc, lo_MainNode)
  End If
    
  'MAT DESCRIPTION
  ls_Request = "exec DPC_SAPMaterialCreateMatDesc_lst $COF_Id$,$OFD_Id$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Id$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
  lc_CursorMaster = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    
  If mo_Db.RowCount(lc_CursorMaster) > 0 Then
      Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "MATL_DESCRIPTIONS", "")
      
      Call mo_Db.First(lc_CursorMaster)
      
      While Not mo_Db.EOF(lc_CursorMaster)
                          
          ls_ATR_Value = GetATRValue(lc_CursorXML, lc_CursorMaster, "MATL_DESC")
          ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                          
          la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
          For ll_Index = 0 To UBound(la_StrValues)
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "MATL_DESC_GROUP", "")
    
            Call CreateXMLNode("MATL_DESC", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubNode)
            Call CreateXMLNode("MD_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MD_LANGU"), lo_XMLDoc, lo_SubNode)
          Next
    
          mo_Db.Next (lc_CursorMaster)
      Wend
  End If
  
  mo_Db.Close (lc_CursorMaster)
        
  
  ll_OFD_PU = mo_Db.GetFields(lc_Header, "OFD_PU")

  If (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Or (StrComp(ls_UOM, DPC_UOM_PCS, vbTextCompare) = 0) Then
    Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "ALT_UOMS", "")
    Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "ALT_UOM_GROUP", "")
        ll_Nominator = 1000
        ll_Denominator = Round(mo_Db.GetFields(lc_Header, "ModuleSurface") * 1000, 0)
        
        Call CreateXMLNode("ALT_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "BASE_UOM_M2"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("NUMERATOR", lc_CursorXML, ll_Nominator, lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("DENOMINATOR", lc_CursorXML, ll_Denominator, lo_XMLDoc, lo_SubNode)
  ElseIf (StrComp(ls_UOM, DPC_UOM_PU, vbTextCompare) = 0) And (ll_OFD_PU > 0) Then
    Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "ALT_UOMS", "")
    Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "ALT_UOM_GROUP", "")
    ll_Nominator = ll_OFD_PU
    ll_Denominator = 1
    Call CreateXMLNode("ALT_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "BASE_UOM_PCS"), lo_XMLDoc, lo_SubNode)
    Call CreateXMLNode("NUMERATOR", lc_CursorXML, ll_Nominator, lo_XMLDoc, lo_SubNode)
    Call CreateXMLNode("DENOMINATOR", lc_CursorXML, ll_Denominator, lo_XMLDoc, lo_SubNode)
  End If
  
  'MAT ATTRIBUTES
  ls_Request = "exec DPC_SAPMaterialCreateMatAttr_lst $COF_Id$,$OFD_Id$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Id$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
  lc_CursorMaster = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    
  If mo_Db.RowCount(lc_CursorMaster) > 0 Then
      Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "MATL_ATTRIBUTES", "")
      
      Call mo_Db.First(lc_CursorMaster)
      
      While Not mo_Db.EOF(lc_CursorMaster)
                    
          ls_ATR_Value = GetATRValue(lc_CursorXML, lc_CursorMaster, "MATL_ATTRIBUTE")
          ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                    
          la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
          
          For ll_Index = 0 To UBound(la_StrValues)
      
              Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "MATL_ATTR_GROUP", "")
          
              Call CreateXMLNode("MATL_ATTRIBUTE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubNode)
              Call CreateXMLNode("MA_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MA_LANGU"), lo_XMLDoc, lo_SubNode)
          Next
    
          mo_Db.Next (lc_CursorMaster)
      Wend
  End If
  
  mo_Db.Close (lc_CursorMaster)
  
  
  'PLANTS
  Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "PLANTS", "")
  
  For ll_Index = 1 To 4
    If mo_Db.GetFields(lc_Header, "PLANT_CODE_" & ll_Index) <> "" Or mo_Db.GetFields(lc_Header, "ORIGIN_IND_" & ll_Index) <> "" Or mo_Db.GetFields(lc_Header, "SP_PROC_TYPE_" & ll_Index) <> "" Then
           
        Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "PLANT_GROUP", "")
        
        Call CreateXMLNode("PLANT_CODE", lc_CursorXML, mo_Db.GetFields(lc_Header, "PLANT_CODE_" & ll_Index), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("ORIGIN_IND", lc_CursorXML, mo_Db.GetFields(lc_Header, "ORIGIN_IND_" & ll_Index), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("SP_PROC_TYPE", lc_CursorXML, mo_Db.GetFields(lc_Header, "SP_PROC_TYPE_" & ll_Index), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("COMM_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "COMM_CODE"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("COUNTRY_ORI", lc_CursorXML, mo_Db.GetFields(lc_Header, "VEN_CountryOrigin"), lo_XMLDoc, lo_SubNode)
                
        If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
          ld_Cost = GetATRValue(lc_CursorXML, lc_Header, "STD_COST_PCS")
        Else
          ld_Cost = GetATRValue(lc_CursorXML, lc_Header, "STD_COST")
        End If
        
        ls_OFD_CurrCode = mo_Db.GetFields(lc_Header, "CURR_CODE")
        ls_RequiredCurrCode = mo_Db.GetFields(lc_Header, "CURR_CODE_" & ll_Index)
        
        If ls_OFD_CurrCode <> ls_RequiredCurrCode Then
            ld_ExRate = mo_Tools.SelectExchangeRate(mo_Db, ls_OFD_CurrCode, ls_RequiredCurrCode, mo_Db.GetFields(lc_Header, "COF_DocDat"))
            ld_Cost = ld_Cost * ld_ExRate
        End If
                
        If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
          Call CreateXMLNode("STD_COST_PCS", lc_CursorXML, ld_Cost, lo_XMLDoc, lo_SubNode)
        Else
          Call CreateXMLNode("STD_COST", lc_CursorXML, ld_Cost, lo_XMLDoc, lo_SubNode)
        End If
                
        Call CreateXMLNode("COST_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "COST_UNIT"), lo_XMLDoc, lo_SubNode)
        
        If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
          Call CreateXMLNode("STK_TRANS_ICTP_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_AMT_PCS"), lo_XMLDoc, lo_SubNode)
        Else
          Call CreateXMLNode("STK_TRANS_ICTP_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_AMT"), lo_XMLDoc, lo_SubNode)
        End If
        Call CreateXMLNode("STK_TRANS_ICTP_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_CURR"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("STK_TRANS_ICTP_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_UNIT"), lo_XMLDoc, lo_SubNode)
        If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
          Call CreateXMLNode("STK_TRANS_ICTP_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_UOM_PCS"), lo_XMLDoc, lo_SubNode)
        Else
          Call CreateXMLNode("STK_TRANS_ICTP_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_UOM"), lo_XMLDoc, lo_SubNode)
        End If
    End If
  Next
  Call mo_Db.Close(lc_Header)
  Call mo_Db.Close(lc_CursorXML)
  
  Set lo_SubNode = Nothing
  Set lo_ParentNode = Nothing
  Set lo_MainNode = Nothing
  
#If LIVE = 0 Then
  MaterialCreateGetXML = SaveXMLDocument(lo_XMLDoc, "AMC_MaterialCreate", "SAPAMCMaterialCreate", False)
  Exit Function
#Else
  MaterialCreateGetXML = SaveXMLDocument(lo_XMLDoc, "AMC_MaterialCreate", "SAPAMCMaterialCreate")
#End If
  
  Exit Function
ErrorHandler:
  
  If lc_CursorMaster <> 0 Then
    mo_Db.Close (lc_CursorMaster)
  End If
  
  If lc_CursorXML <> 0 Then
    mo_Db.Close (lc_CursorXML)
  End If

  Set lo_SubNode = Nothing
  Set lo_ParentNode = Nothing
  Set lo_MainNode = Nothing

  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
  
  Call ErrorHandler("MaterialCreateGetXML")
End Function

Public Function SalesOrderCreate(ByVal as_COF_Id As String, ByVal as_ActionCode As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrorHandler

Dim ls_Xml As String
Dim ls_Response As String
Dim lb_Simulate As Boolean

        SalesOrderCreate = False
        lb_Simulate = as_ActionCode = "T"
        ls_Xml = SalesOrderCreateGetXML(as_COF_Id, as_ActionCode)
        
        If (SendRequest(DPC_SAP_SALESORDER_CREATE, "POST", ls_Xml, ls_Response) = True) Then
            
            'ls_Response = "<?xml version=""1.0"" encoding=""UTF-8""?><AMC_SALES_ORD_CREATE_CHG_RESPONSE><SUCC_FAIL_IND>F</SUCC_FAIL_IND><EPC_ORD_NO>00536.A</EPC_ORD_NO>" & _
            '    "<ERRORS><ERROR_GROUP><SEVERITY_TYPE>E</SEVERITY_TYPE><MSG_CLASS>VP</MSG_CLASS><MSG_NO>200</MSG_NO><MSG_TEXT>No customer master record exists for customer 207691</MSG_TEXT>" & _
            '    "<MSG_PARAMETER>SALES_HEADER_IN</MSG_PARAMETER><MSG_PARM_ROW/></ERROR_GROUP></ERRORS></AMC_SALES_ORD_CREATE_CHG_RESPONSE>"
          If (SalesOrderCreateProcessResponse(ls_Response, as_ErrorMsg, lb_Simulate) = True) Then
              SalesOrderCreate = True
          End If
          If Not lb_Simulate Then
            Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
          End If
        Else
            as_ErrorMsg = ls_Response
        End If
        
  Exit Function
ErrorHandler:
  
  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
  
  Call ErrorHandler("SalesOrderCreate")
End Function

Public Function SalesOrderCreateGetXML(ByVal as_COF_Id As String, ByVal as_ActionCode As String) As String
On Error GoTo ErrorHandler

Dim lo_XmlDocCust As Object
'Dim ll_Version As Long
Dim lo_SubNode As Object
Dim lo_SubSubNode As Object
Dim lo_SubSubSubNode As Object
Dim lo_ParentNode As Object
Dim lo_MainNode As Object
Dim lc_CursorXML As Long
Dim lc_CursorGroup As Long
Dim lc_Header As Long
Dim lc_Lines As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ls_Request As String
Dim ls_ATR_Value As String
Dim ls_ATR_DataLength As Long
Dim la_StrValues() As String
Dim ll_Index As Integer
Dim ld_DelDate As Date
Dim ls_UOM As String
Dim le_CAT_Id As eDPCCategory

  Call mo_Tools.ClearLogInterface(Me)
  ILO_Interface = eDPCXmlExportType.etAMC_SalesOrderCreate
  ILO_MasterId = as_COF_Id
  
  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  
  lc_CursorXML = GetXmlCursor(eDPCXmlExportType.etAMC_SalesOrderCreate)
    
  Set lo_MainNode = lo_XMLDoc.createProcessingInstruction("xml", "version='1.0' encoding='utf-8'")
  lo_XMLDoc.appendChild lo_MainNode
    
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "AMC_SALES_ORD_CREATE_SIMU", "")
  lo_MainNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
      
  ls_Request = "exec DPC_SAPSalesOrderCreateHeader_sel $COF_Id$,$Language_Code$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$Language_Code$", "'E'", , , vbTextCompare)
  lc_Header = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  
  ls_Request = "exec DPC_SAPSalesOrderCreateLines_lst $COF_Id$,'E'"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  lc_Lines = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  ld_DelDate = mo_Db.GetFields(lc_Lines, "OFD_DelDat")
  Do While Not mo_Db.EOF(lc_Lines)
    If ld_DelDate <> mo_Db.GetFields(lc_Lines, "OFD_DelDat") Then
      ld_DelDate = 0
      Exit Do
    End If
    Call mo_Db.Next(lc_Lines)
  Loop
  
  
  Call mo_Db.First(lc_Header)
        
  Call CreateXMLNode("ACTION_CODE", lc_CursorXML, as_ActionCode, lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("SALES_ORG", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SALES_ORG"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("DISTR_CHAN", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DISTR_CHAN"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("SOLDTO_CUST_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SOLDTO_CUST_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("CONTACT_NAME", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CONTACT_NAME"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("CUST_PO_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CUST_PO_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("CUST_PO_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CUST_PO_DATE"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("PROJ_ID_KEY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "PROJ_ID_KEY"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("AMC_PROJ_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "AMC_PROJ_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("PROJ_ID_DESC", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "PROJ_ID_DESC"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("EPC_OFFER_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_OFFER_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("EPC_OFFER_VERS_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_OFFER_VERS_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("EPC_ORD_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_ORD_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("EPC_ORD_VERS_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_ORD_VERS_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("HDR_REQ_DEL_DATE", lc_CursorXML, ld_DelDate, lo_XMLDoc, lo_MainNode)
  
  'DELIV ADDRESS
  ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME")
  ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
  If Len(ls_ATR_Value) > 0 Then
    Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "DELIV_ADDRESS", "")
                
    la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
      
    If UBound(la_StrValues) = 0 Then
        Call CreateXMLNode("DA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_ParentNode)
    
        ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME2")
        ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
        Call CreateXMLNode("DA_NAME2", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_ParentNode)
        
        If UBound(la_StrValues) = 1 Then
            Call CreateXMLNode("DA_NAME3", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_ParentNode)
        End If
    Else
        Call CreateXMLNode("DA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_ParentNode)
        Call CreateXMLNode("DA_NAME2", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_ParentNode)
    
        ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME2")
        ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
        
        Call CreateXMLNode("DA_NAME3", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_ParentNode)
        
        If UBound(la_StrValues) = 1 Then
            Call CreateXMLNode("DA_NAME4", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_ParentNode)
        End If
    End If
    
              
    Call CreateXMLNode("DA_STREET", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_STREET"), lo_XMLDoc, lo_ParentNode)
    Call CreateXMLNode("DA_CITY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_CITY"), lo_XMLDoc, lo_ParentNode)
    Call CreateXMLNode("DA_REGION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_REGION"), lo_XMLDoc, lo_ParentNode)
    Call CreateXMLNode("DA_POSTL_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_POSTL_CODE"), lo_XMLDoc, lo_ParentNode)
    Call CreateXMLNode("DA_COUNTRY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_COUNTRY"), lo_XMLDoc, lo_ParentNode)
  
  End If
  
  'HDR_TEXTS
  If Len(GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE1")) > 0 Or Len(GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE2")) > 0 Then
                  
    Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "HDR_TEXTS", "")
                  
    ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE1")
    ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
    If Len(ls_ATR_Value) > 0 Then
        Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "HDR_TEXT_GROUP", "")
                
        Call CreateXMLNode("TEXT_ID1", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_ID1"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_LANGU"), lo_XMLDoc, lo_SubNode)
             
        Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "TEXT_LINES", "")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
        
        For ll_Index = 0 To UBound(la_StrValues)
            Call CreateXMLNode("TEXT_LINE1", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubNode)
        Next
        
        'Call CreateXMLNode("TEXT_LINE1", lc_CursorXML, ls_ATR_Value, lo_XMLDoc, lo_SubSubNode)
    End If
    
    ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE2")
    ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
    If Len(ls_ATR_Value) > 0 Then
        Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "HDR_TEXT_GROUP", "")
                
        Call CreateXMLNode("TEXT_ID2", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_ID2"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_LANGU"), lo_XMLDoc, lo_SubNode)
             
        Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "TEXT_LINES", "")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
        
        For ll_Index = 0 To UBound(la_StrValues)
            Call CreateXMLNode("TEXT_LINE2", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubNode)
        Next
        
        'Call CreateXMLNode("TEXT_LINE2", lc_CursorXML, ls_ATR_Value, lo_XMLDoc, lo_SubSubNode)
    End If
  End If
      
  'LINES
  If mo_Db.RowCount(lc_Lines) > 0 Then
      
    Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "LINES", "")
      
    Call mo_Db.First(lc_Lines)
    
    While Not mo_Db.EOF(lc_Lines)
      
      ls_UOM = GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM")
      le_CAT_Id = mo_Db.GetFields(lc_Lines, "CAT_Id")
      
      Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "LINE_GROUP", "")
      Call CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MATERIAL_NO"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("EPC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "EPC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("FREE_OF_CHARGE_IND", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "FREE_OF_CHARGE_IND"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("MFG_PRE_RESERV_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_NO"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("MFG_PRE_RESERV_LIN_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_LIN_POS"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("CUST_POSITION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "CUST_POSITION"), lo_XMLDoc, lo_SubNode)
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
        Call CreateXMLNode("SALES_QTY_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY_PCS"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("SALES_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM_PCS"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("LINE_PRICE_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT_PCS"), lo_XMLDoc, lo_SubNode)
      Else
        Call CreateXMLNode("SALES_QTY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("SALES_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("LINE_PRICE_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT"), lo_XMLDoc, lo_SubNode)
      End If
      
      Call CreateXMLNode("LINE_PRICE_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_CURR"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("LINE_PRICE_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UNIT"), lo_XMLDoc, lo_SubNode)
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
        Call CreateXMLNode("LINE_PRICE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM_PCS"), lo_XMLDoc, lo_SubNode)
      Else
        Call CreateXMLNode("LINE_PRICE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM"), lo_XMLDoc, lo_SubNode)
      End If
      Call CreateXMLNode("SHIPPING_PLANT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SHIPPING_PLANT"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("ITM_REQ_DEL_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "ITM_REQ_DEL_DATE"), lo_XMLDoc, lo_SubNode)

      
      ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LINE")
      ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")

      If Len(ls_ATR_Value) > 0 Then
        Set lo_SubNode = AppendElement(lo_XMLDoc, lo_SubNode, "ITM_TEXTS", "")
            
        Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "ITM_TEXT_GROUP", "")
            
        Call CreateXMLNode("TEXT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "TEXT_ID"), lo_XMLDoc, lo_SubSubNode)
        Call CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LANGU"), lo_XMLDoc, lo_SubSubNode)
            
        Set lo_SubSubSubNode = AppendElement(lo_XMLDoc, lo_SubSubNode, "TEXT_LINES", "")
                                
        la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
        
        For ll_Index = 0 To UBound(la_StrValues)
            Call CreateXMLNode("TEXT_LINE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubSubNode)
        Next
      End If

      mo_Db.Next (lc_Lines)
    Wend
  End If
  
  Call mo_Db.Close(lc_Lines)
  Call mo_Db.Close(lc_Header)
 
  Call mo_Db.Close(lc_CursorXML)
  
  Set lo_SubSubNode = Nothing
  Set lo_SubNode = Nothing
  Set lo_ParentNode = Nothing
  Set lo_MainNode = Nothing
  
#If LIVE = 0 Then
  SalesOrderCreateGetXML = SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderCreate", "SAPAMCSalesOrderCreate", False)
  Exit Function
#Else
  SalesOrderCreateGetXML = SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderCreate", "SAPAMCSalesOrderCreate")
#End If
  
  Exit Function
ErrorHandler:
  
  If lc_Lines <> 0 Then
    mo_Db.Close (lc_Lines)
  End If
  
  If lc_CursorXML <> 0 Then
    mo_Db.Close (lc_CursorXML)
  End If

  Set lo_SubSubNode = Nothing
  Set lo_SubNode = Nothing
  Set lo_ParentNode = Nothing
  Set lo_MainNode = Nothing

  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
  
  Call ErrorHandler("SalesOrderCreateGetXML")
End Function

Public Function SalesOrderCreate_v2(ByVal as_COF_Id As String, ByVal as_ActionCode As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrorHandler

Dim ls_Xml As String
Dim ls_Response As String
Dim ls_Filename As String

  SalesOrderCreate_v2 = False
  
  ls_Filename = SalesOrderCreateGetXML_v2(as_COF_Id, as_ActionCode)
  
  Call TransferXMLDocument(ls_Filename, as_ErrorMsg)
  
  'If (SendRequest(DPC_SAP_SALESORDER_CREATE, "POST", ls_Xml, ls_Response) = True) Then
      
      'ls_Response = "<?xml version=""1.0"" encoding=""UTF-8""?><AMC_SALES_ORD_CREATE_CHG_RESPONSE><SUCC_FAIL_IND>F</SUCC_FAIL_IND><EPC_ORD_NO>00536.A</EPC_ORD_NO>" & _
      '    "<ERRORS><ERROR_GROUP><SEVERITY_TYPE>E</SEVERITY_TYPE><MSG_CLASS>VP</MSG_CLASS><MSG_NO>200</MSG_NO><MSG_TEXT>No customer master record exists for customer 207691</MSG_TEXT>" & _
      '    "<MSG_PARAMETER>SALES_HEADER_IN</MSG_PARAMETER><MSG_PARM_ROW/></ERROR_GROUP></ERRORS></AMC_SALES_ORD_CREATE_CHG_RESPONSE>"
     
      'If (SalesOrderCreateProcessResponse(ls_Response, as_ErrorMsg) = True) Then
      '    SalesOrderCreate = True
      'End If
      
      'Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
      
  'Else
      'as_ErrorMsg = ls_Response
  'End If
  Exit Function
ErrorHandler:
  
  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
  
  Call ErrorHandler("SalesOrderCreate_v2")
End Function

Public Function SalesOrderCreateGetXML_v2(ByVal as_COF_Id As String, ByVal as_ActionCode As String) As String
On Error GoTo ErrorHandler

Dim lo_XmlDocCust As Object
'Dim ll_Version As Long
Dim lo_SubNode As Object
Dim lo_SubSubNode As Object
Dim lo_SubSubSubNode As Object
Dim lo_ParentNode As Object
Dim lo_MainNode As Object
Dim lc_CursorXML As Long
Dim lc_CursorGroup As Long
Dim lc_Header As Long
Dim lc_Lines As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ls_Request As String
Dim ls_ATR_Value As String
Dim ll_ATR_DataLength As Long
Dim la_StrValues() As String
Dim ll_Index As Integer
Dim ld_DelDate As Date
Dim ls_UOM As String
Dim le_CAT_Id As eDPCCategory
Dim ll_Count As Long
Dim ls_Filename As String

  Call mo_Tools.ClearLogInterface(Me)
  ILO_Interface = eDPCXmlExportType.etAMC_SalesOrderCreate_v2
  ILO_MasterId = as_COF_Id
  
  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  
  lc_CursorXML = GetXmlCursor(eDPCXmlExportType.etAMC_SalesOrderCreate_v2)
    
  Set lo_MainNode = lo_XMLDoc.createProcessingInstruction("xml", "version='1.0' encoding='utf-8'")
  lo_XMLDoc.appendChild lo_MainNode
    
    
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "AMC_SO_DEMAND_CREATE_CHANGE", "")
  lo_MainNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
      
  ls_Request = "exec DPC_BaeSalesOrderCreateHeader_sel $COF_Id$,$Language_Code$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$Language_Code$", "'E'", , , vbTextCompare)
  lc_Header = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  
  ls_Request = "exec DPC_BaeSalesOrderCreateLines_lst $COF_Id$,'E'"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  lc_Lines = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  ld_DelDate = mo_Db.GetFields(lc_Lines, "OFD_DelDat")
  Do While Not mo_Db.EOF(lc_Lines)
    If ld_DelDate <> mo_Db.GetFields(lc_Lines, "OFD_DelDat") Then
      ld_DelDate = 0
      Exit Do
    End If
    Call mo_Db.Next(lc_Lines)
  Loop
  
  
  Call mo_Db.First(lc_Header)
        
  'Call CreateXMLNode("ACTION_CODE", lc_CursorXML, as_ActionCode, lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("COMP_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "COMP_CODE"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("EPC_ORD_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_ORD_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("SALES_ORG", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SALES_ORG"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("DISTR_CHAN", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DISTR_CHAN"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("SOLDTO_CUST_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SOLDTO_CUST_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("CLIENT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CLIENT_ID"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("CONTACT_NAME", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CONTACT_NAME"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("CUST_PO_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CUST_PO_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("CUST_PO_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CUST_PO_DATE"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("PROJ_ID_KEY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "PROJ_ID_KEY"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("AMC_PROJ_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "AMC_PROJ_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("PROJ_ID_DESC", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "PROJ_ID_DESC"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("EPC_OFFER_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_OFFER_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("EPC_OFFER_VERS_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_OFFER_VERS_NO"), lo_XMLDoc, lo_MainNode)
  'Call CreateXMLNode("EPC_ORD_VERS_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_ORD_VERS_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("HDR_REQ_DEL_DATE", lc_CursorXML, ld_DelDate, lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("VERP_ART", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "VERP_ART"), lo_XMLDoc, lo_MainNode)
  
  'customer - sales project address
  ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "CA_NAME")
  ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
    
  If UBound(la_StrValues) = 0 Then
      Call CreateXMLNode("CA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode)
  
      ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "CA_NAME2")
      ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
              
      la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
      Call CreateXMLNode("CA_NAME2", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode)
      
      If UBound(la_StrValues) = 1 Then
          Call CreateXMLNode("CA_NAME3", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode)
      End If
  Else
      Call CreateXMLNode("CA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode)
      Call CreateXMLNode("CA_NAME2", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode)
  
      ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "CA_NAME2")
      ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
              
      la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
      
      Call CreateXMLNode("CA_NAME3", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode)
      
      If UBound(la_StrValues) = 1 Then
          Call CreateXMLNode("CA_NAME4", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode)
      End If
  End If
  Call CreateXMLNode("CA_STREET", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CA_STREET"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("CA_CITY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CA_CITY"), lo_XMLDoc, lo_MainNode)
  'Call CreateXMLNode("CA_REGION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CA_REGION"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("CA_POSTL_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CA_POSTL_CODE"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("CA_COUNTRY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CA_COUNTRY"), lo_XMLDoc, lo_MainNode)
  
  'DELIV ADDRESS
  ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME")
  ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
  If Len(ls_ATR_Value) > 0 Then
    'Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "DELIV_ADDRESS", "")
                
    la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
      
    If UBound(la_StrValues) = 0 Then
        Call CreateXMLNode("DA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode)
    
        ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME2")
        ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
        Call CreateXMLNode("DA_NAME2", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode)
        
        If UBound(la_StrValues) = 1 Then
            Call CreateXMLNode("DA_NAME3", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode)
        End If
    Else
        Call CreateXMLNode("DA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode)
        Call CreateXMLNode("DA_NAME2", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode)
    
        ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME2")
        ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
        
        Call CreateXMLNode("DA_NAME3", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode)
        
        If UBound(la_StrValues) = 1 Then
            Call CreateXMLNode("DA_NAME4", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode)
        End If
    End If
    
              
    Call CreateXMLNode("DA_STREET", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_STREET"), lo_XMLDoc, lo_MainNode)
    Call CreateXMLNode("DA_CITY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_CITY"), lo_XMLDoc, lo_MainNode)
    'Call CreateXMLNode("DA_REGION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_REGION"), lo_XMLDoc, lo_MainNode)
    Call CreateXMLNode("DA_POSTL_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_POSTL_CODE"), lo_XMLDoc, lo_MainNode)
    Call CreateXMLNode("DA_COUNTRY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_COUNTRY"), lo_XMLDoc, lo_MainNode)
  
  End If
  
  'HDR_TEXTS
  If Len(GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE1")) > 0 Or Len(GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE2")) > 0 Then
                  
    'Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "HDR_TEXTS", "")
                  
    ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE1")
    ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
    If (Len(ls_ATR_Value) > 0) And (ll_ATR_DataLength > 0) Then
        'Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "HDR_TEXT_GROUP", "")
                
        Call CreateXMLNode("TEXT_ID1", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_ID1"), lo_XMLDoc, lo_MainNode)
        'Call CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_LANGU"), lo_XMLDoc, lo_MainNode)
             
        'Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "TEXT_LINES", "")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
        
        ll_Count = UBound(la_StrValues)
        If ll_Count > 2 Then ll_Count = 2
        For ll_Index = 0 To ll_Count
            Call AppendElement(lo_XMLDoc, lo_MainNode, "TEXT_LINE" & (ll_Index + 1), la_StrValues(ll_Index))
            'Call CreateXMLNode("TEXT_LINE1", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubNode)
        Next
        
        'Call CreateXMLNode("TEXT_LINE1", lc_CursorXML, ls_ATR_Value, lo_XMLDoc, lo_SubSubNode)
    End If
    
    ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE2")
    ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
    If (Len(ls_ATR_Value) > 0) And (ll_ATR_DataLength > 0) Then
        'Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "HDR_TEXT_GROUP", "")
                
        Call CreateXMLNode("TEXT_ID2", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_ID2"), lo_XMLDoc, lo_MainNode)
        'Call CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_LANGU"), lo_XMLDoc, lo_MainNode)
             
        'Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "TEXT_LINES", "")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
        
        ll_Count = UBound(la_StrValues)
        If ll_Count > 2 Then ll_Count = 2
        For ll_Index = 0 To ll_Count
            Call AppendElement(lo_XMLDoc, lo_MainNode, "TEXT_LINE" & (ll_Index + 1), la_StrValues(ll_Index))
            'Call CreateXMLNode("TEXT_LINE2", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubNode)
        Next
        
        'Call CreateXMLNode("TEXT_LINE2", lc_CursorXML, ls_ATR_Value, lo_XMLDoc, lo_SubSubNode)
    End If
  End If
      
  'LINES
  If mo_Db.RowCount(lc_Lines) > 0 Then
      
    Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "LINES", "")
      
    Call mo_Db.First(lc_Lines)
    
    While Not mo_Db.EOF(lc_Lines)
      
      ls_UOM = GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM")
      le_CAT_Id = mo_Db.GetFields(lc_Lines, "CAT_Id")
      
      Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "LINE_GROUP", "")
      
      
      Call CreateXMLNode("LINE_ACTION_CODE", lc_CursorXML, as_ActionCode, lo_XMLDoc, lo_SubNode)
      
      Call CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MATERIAL_NO"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("EPC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "EPC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("FREE_OF_CHARGE_IND", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "FREE_OF_CHARGE_IND"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("MFG_PRE_RESERV_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_NO"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("MFG_PRE_RESERV_LIN_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_LIN_POS"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("CUST_POSITION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "CUST_POSITION"), lo_XMLDoc, lo_SubNode)
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
        Call CreateXMLNode("SALES_QTY_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY_PCS"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("SALES_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM_PCS"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("LINE_PRICE_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT_PCS"), lo_XMLDoc, lo_SubNode)
      Else
        Call CreateXMLNode("SALES_QTY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY") * 1000, lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("SALES_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM"), lo_XMLDoc, lo_SubNode)
        Call CreateXMLNode("LINE_PRICE_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT"), lo_XMLDoc, lo_SubNode)
      End If
      
      Call CreateXMLNode("LINE_PRICE_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_CURR"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("LINE_PRICE_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UNIT"), lo_XMLDoc, lo_SubNode)
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
        Call CreateXMLNode("LINE_PRICE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM_PCS"), lo_XMLDoc, lo_SubNode)
      Else
        Call CreateXMLNode("LINE_PRICE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM"), lo_XMLDoc, lo_SubNode)
      End If
      Call CreateXMLNode("SHIPPING_PLANT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SHIPPING_PLANT"), lo_XMLDoc, lo_SubNode)
      Call CreateXMLNode("ITM_REQ_DEL_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "ITM_REQ_DEL_DATE"), lo_XMLDoc, lo_SubNode)

      
      ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LINE")
      ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")

      If (Len(ls_ATR_Value) > 0) And (ll_ATR_DataLength > 0) Then
        'Set lo_SubNode = AppendElement(lo_XMLDoc, lo_SubNode, "ITM_TEXTS", "")
            
        'Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "ITM_TEXT_GROUP", "")
            
        Call CreateXMLNode("TEXT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "TEXT_ID"), lo_XMLDoc, lo_SubNode)
        'Call CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LANGU"), lo_XMLDoc, lo_SubNode)
            
        'Set lo_SubSubSubNode = AppendElement(lo_XMLDoc, lo_SubSubNode, "TEXT_LINES", "")
                                
        la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
        ll_Count = UBound(la_StrValues)
        If ll_Count > 2 Then ll_Count = 2
        
        For ll_Index = 0 To ll_Count
            Call AppendElement(lo_XMLDoc, lo_SubNode, "TEXT_LINE" & (ll_Index + 1), la_StrValues(ll_Index))
            'Call CreateXMLNode("TEXT_LINE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubSubNode)
        Next
      End If

      mo_Db.Next (lc_Lines)
    Wend
  End If
  
  ls_Filename = mo_Db.GetFields(lc_Lines, "OFD_OrdNrB7") & "_" & Format(Now, "yyyymmdd_hhmmss")
  
  Call mo_Db.Close(lc_Lines)
  Call mo_Db.Close(lc_Header)
 
  Call mo_Db.Close(lc_CursorXML)
  
  Set lo_SubSubNode = Nothing
  Set lo_SubNode = Nothing
  Set lo_ParentNode = Nothing
  Set lo_MainNode = Nothing
  
  Call SaveXMLDocument(lo_XMLDoc, ls_Filename, "SAPAMCSalesOrderCreate", False, True)
  SalesOrderCreateGetXML_v2 = ls_Filename
'
'#If LIVE = 0 Then
'  SalesOrderCreateGetXML_v2 = SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderCreate", "SAPAMCSalesOrderCreate", False, True)
'  Exit Function
'#Else
'  SalesOrderCreateGetXML_v2 = SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderCreate", "SAPAMCSalesOrderCreate")
'#End If
  
  Exit Function
ErrorHandler:
  
  If lc_Lines <> 0 Then
    mo_Db.Close (lc_Lines)
  End If
  
  If lc_CursorXML <> 0 Then
    mo_Db.Close (lc_CursorXML)
  End If

  Set lo_SubSubNode = Nothing
  Set lo_SubNode = Nothing
  Set lo_ParentNode = Nothing
  Set lo_MainNode = Nothing

  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
  
  Call ErrorHandler("SalesOrderCreateGetXML")
End Function

Public Function SalesOrderCreateProcessResponse(ByVal as_Response As String, ByRef as_ErrorMsg As String, ByVal ab_Simulate As Boolean) As Boolean
On Error GoTo ErrorHandler

Dim lo_XMLDoc As Object
Dim lo_NodeElem As Object
Dim lo_NodeList As Object
Dim lo_NodeId As Object
Dim ls_value As String
Dim ls_COF_Code As String
Dim ls_SAP_Code As String
Dim ll_Cursor As Long
Dim lb_InTransaction As Boolean
Dim ll_COF_Id As String
Dim ll_iConcurrency As Long
Dim ls_OFD_Pos() As String
Dim ls_OFD_PosSAP() As String
Dim ls_Request As String
Dim ll_Index As Integer
Dim ls_ValidationXSD As String
Dim ls_FormatterXML As String
Dim ls_Error As String

    SalesOrderCreateProcessResponse = False
    
    Call LoadXMLFiles("SAPAMCSalesOrderChangeResponse", ls_ValidationXSD, ls_FormatterXML)
      
    Call ValidateXMLFile(as_Response, "", ls_ValidationXSD, True)

    Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
    
    lo_XMLDoc.async = False
    Call lo_XMLDoc.loadXML(as_Response)
    
    If (lo_XMLDoc.parseError.errorCode <> 0) Then
    
        ILO_Error = lo_XMLDoc.parseError.reason
        ILO_Status = eDPCInterfaceStatus.isFailed
        
        Err.Raise ArmErr.CompFncFailed, "Parse Error:", lo_XMLDoc.parseError.reason
       
    Else
       Set lo_NodeElem = lo_XMLDoc.selectSingleNode("//SUCC_FAIL_IND")
       ls_value = lo_NodeElem.nodeTypedValue
       If ls_value = "S" Then
                   
            If Not ab_Simulate Then
              ls_COF_Code = lo_XMLDoc.selectSingleNode("//EPC_ORD_NO").nodeTypedValue
              ls_SAP_Code = lo_XMLDoc.selectSingleNode("//SAP_ORD_NO").nodeTypedValue
              
              Set lo_NodeList = lo_XMLDoc.selectNodes("//LINE_GROUP")
      
              If lo_NodeList.length > 0 Then
                  
                  ReDim ls_OFD_Pos(lo_NodeList.length - 1)
                  ReDim ls_OFD_PosSAP(lo_NodeList.length - 1)
                  ll_Index = 0
                  
                  For Each lo_NodeElem In lo_NodeList
                      ls_OFD_Pos(ll_Index) = lo_NodeElem.selectSingleNode("EPC_ORD_LINE_POS").nodeTypedValue
                      ls_OFD_PosSAP(ll_Index) = lo_NodeElem.selectSingleNode("SAP_ORD_LINE_POS").nodeTypedValue
                      ll_Index = ll_Index + 1
                  Next
                              
                  ls_Request = "exec CAP_Offer_sel2 $COF_Code$,'E'"
                  ls_Request = Replace(ls_Request, "$COF_Code$", mo_Tools.SQLStr(ls_COF_Code), , , vbTextCompare)
                  ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request, 1)
                  
                  ll_COF_Id = mo_Db.GetFields(ll_Cursor, "COF_Id")
                  ll_iConcurrency = mo_Db.GetFields(ll_Cursor, "iConcurrency")
                              
                  Call mo_Db.Close(ll_Cursor)
                  
                  Call mo_Tools.BeginTran(mo_Db, ml_U_Code, SCREEN_NAME, "CAP_Offer_SAPResponse")
                  lb_InTransaction = True
                  
                  ls_Request = "exec CAP_Offer_SAPResponse_upd $COF_Code$,$COF_CodeSAP$,$COF_SAPStat$,$iConcurrency$,$Z_Last_Upd_User$"
                  ls_Request = Replace(ls_Request, "$COF_Code$", mo_Tools.SQLStr(ls_COF_Code), , , vbTextCompare)
                  ls_Request = Replace(ls_Request, "$COF_CodeSAP$", mo_Tools.SQLStr(ls_SAP_Code), , , vbTextCompare)
                  ls_Request = Replace(ls_Request, "$COF_SAPStat$", 1, , , vbTextCompare)
                  ls_Request = Replace(ls_Request, "$iConcurrency$", ll_iConcurrency, , , vbTextCompare)
                  ls_Request = Replace(ls_Request, "$Z_Last_Upd_User$", ml_U_Code, , , vbTextCompare)
                  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request, 1)
                  
                  For ll_Index = 0 To lo_NodeList.length - 1
                  
                      ls_Request = "exec CAP_OfferDetail_SAPResponse_upd $COF_Id$,$OFD_Pos$,$OFD_PosSAP$,$Z_Last_Upd_User$"
                      ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(ll_COF_Id), , , vbTextCompare)
                      ls_Request = Replace(ls_Request, "$OFD_Pos$", mo_Tools.SQLStr(ls_OFD_Pos(ll_Index)), , , vbTextCompare)
                      ls_Request = Replace(ls_Request, "$OFD_PosSAP$", mo_Tools.SQLStr(ls_OFD_PosSAP(ll_Index)), , , vbTextCompare)
                      ls_Request = Replace(ls_Request, "$Z_Last_Upd_User$", ml_U_Code, , , vbTextCompare)
                      Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request, 1)
                  
                  Next
                              
                  Call mo_Tools.CommitTran(mo_Db, ml_U_Code, SCREEN_NAME, "CAP_Offer_SAPResponse")
                  lb_InTransaction = False
                  
              End If
            End If
            SalesOrderCreateProcessResponse = True
     
            ILO_Status = eDPCInterfaceStatus.isOK
       Else
            ILO_Status = eDPCInterfaceStatus.isFailed
       End If
       
       'read error, warrning, info messages
       Set lo_NodeList = lo_XMLDoc.selectNodes("//ERROR_GROUP")
            
       For Each lo_NodeElem In lo_NodeList
            as_ErrorMsg = as_ErrorMsg & lo_NodeElem.selectSingleNode("MSG_TEXT").nodeTypedValue & vbNewLine
       Next
                      
       ILO_Error = as_ErrorMsg
    End If
    
    Set lo_NodeElem = Nothing
    Set lo_NodeList = Nothing
    Set lo_XMLDoc = Nothing
        
  Exit Function
ErrorHandler:
    
    If lb_InTransaction Then
        Call mo_Tools.RollbackTran(mo_Db, ml_U_Code, SCREEN_NAME, "CAP_Offer_SAPResponse")
    End If

    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
    End If
    
    Set lo_NodeElem = Nothing
    Set lo_NodeList = Nothing
    Set lo_XMLDoc = Nothing
    
  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
  
  Call ErrorHandler("SalesOrderCreateProcessResponse")
End Function

Public Function ProcessBasicResponse(ByVal as_Response As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrorHandler

Dim lo_XMLDoc As Object
Dim lo_NodeElem As Object
Dim lo_NodeList As Object
Dim lo_NodeId As Object
Dim ls_value As String
Dim ls_ValidationXSD As String
Dim ls_FormatterXML As String
Dim ls_Error As String

    ProcessBasicResponse = False
    
    Call LoadXMLFiles("SAPAMCBasicResponse", ls_ValidationXSD, ls_FormatterXML)
      
    Call ValidateXMLFile(as_Response, "", ls_ValidationXSD, True)

    Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
    
    lo_XMLDoc.async = False
    Call lo_XMLDoc.loadXML(as_Response)
    
    If (lo_XMLDoc.parseError.errorCode <> 0) Then
    
        ILO_Error = lo_XMLDoc.parseError.reason
        ILO_Status = eDPCInterfaceStatus.isFailed
    
        Err.Raise ArmErr.CompFncFailed, "Parse Error:", lo_XMLDoc.parseError.reason
       
    Else
       Set lo_NodeElem = lo_XMLDoc.selectSingleNode("//SUCC_FAIL_IND")
       ls_value = lo_NodeElem.nodeTypedValue
       If ls_value = "F" Then
       
            ILO_Status = eDPCInterfaceStatus.isFailed
            ProcessBasicResponse = False
       
       ElseIf ls_value = "S" Then
       
            ILO_Status = eDPCInterfaceStatus.isOK
            ProcessBasicResponse = True
       End If
              
    End If
    
    'read error, warrning, info messages
    Set lo_NodeList = lo_XMLDoc.selectNodes("//ERROR_GROUP")
        
    For Each lo_NodeElem In lo_NodeList
        as_ErrorMsg = as_ErrorMsg & lo_NodeElem.selectSingleNode("MSG_TEXT").nodeTypedValue & vbNewLine
    Next
    
    ILO_Error = as_ErrorMsg
    
    Set lo_NodeElem = Nothing
    Set lo_NodeList = Nothing
    Set lo_XMLDoc = Nothing
    
  Exit Function
ErrorHandler:
        
    Set lo_NodeElem = Nothing
    Set lo_NodeList = Nothing
    Set lo_XMLDoc = Nothing
    
  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
  
  Call ErrorHandler("ProcessBasicResponse")
End Function


Public Function SalesOrderLineCancelAddReplace(ByVal as_COF_Id As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrorHandler

Dim ls_Xml As String
Dim ls_Response As String

        SalesOrderLineCancelAddReplace = False
        
        ls_Xml = SalesOrderLineCancelAddReplaceGetXML(as_COF_Id)
        
        If (SendRequest(DPC_SAP_SALESORDER_CHANGE, "POST", ls_Xml, ls_Response) = True) Then
                       
            If (SalesOrderCreateProcessResponse(ls_Response, as_ErrorMsg, False) = True) Then
                SalesOrderLineCancelAddReplace = True
            End If
            
            Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
        Else
            as_ErrorMsg = ls_Response
        End If
        
  Exit Function
ErrorHandler:
  
  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)

  Call ErrorHandler("SalesOrderLineCancelAddReplace")
End Function

Public Function SalesOrderLineCancelAddReplaceGetXML(ByVal as_COF_Id As String) As String
On Error GoTo ErrorHandler

Dim lo_XmlDocCust As Object
'Dim ll_Version As Long
Dim lo_SubNode1 As Object, lo_SubNode2 As Object, lo_SubNode3 As Object, lo_SubNode4 As Object, lo_SubNode5 As Object
Dim lo_ParentNode As Object, lo_SubNode As Object
Dim lo_MainNode As Object
Dim lc_CursorMaster As Long
Dim lc_CursorXML As Long
Dim lc_CursorGroup As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ls_Request As String
Dim ls_ATR_Value As String
Dim ls_ATR_DataLength As Long
Dim la_StrValues() As String
Dim ll_Index As Integer
Dim ls_UOM As String
Dim le_CAT_Id As eDPCCategory

On Error GoTo ErrorHandler
  
  Call mo_Tools.ClearLogInterface(Me)
  ILO_Interface = eDPCXmlExportType.etAMC_SalesOrderLineCancelAddReplace
  ILO_MasterId = as_COF_Id
  
  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  
  lc_CursorXML = GetXmlCursor(eDPCXmlExportType.etAMC_SalesOrderLineCancelAddReplace)
    
  Set lo_MainNode = lo_XMLDoc.createProcessingInstruction("xml", "version='1.0' encoding='utf-8'")
  lo_XMLDoc.appendChild lo_MainNode
    
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "AMC_SALES_ORD_LINE_CANCEL_ADD_REPLACE", "")
  lo_MainNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
      
  ls_Request = "exec DPC_SAPSalesOrderLineChangeHeader_sel $COF_Id$,$Language_Code$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$Language_Code$", "'E'", , , vbTextCompare)
  lc_CursorMaster = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  
  Call mo_Db.First(lc_CursorMaster)
        
  Call CreateXMLNode("SAP_ORD_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SAP_ORD_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("EPC_ORD_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "EPC_ORD_NO"), lo_XMLDoc, lo_MainNode)
                
  mo_Db.Close (lc_CursorMaster)

  'LINES
  ls_Request = "exec DPC_SAPSalesOrderLineChangeLines_lst $COF_Id$,'E'"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  lc_CursorMaster = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    
  If mo_Db.RowCount(lc_CursorMaster) > 0 Then
      
      Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "LINES", "")
      
      Call mo_Db.First(lc_CursorMaster)
      
      While Not mo_Db.EOF(lc_CursorMaster)
                
          ls_UOM = GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_UOM")
          le_CAT_Id = mo_Db.GetFields(lc_CursorMaster, "CAT_Id")
          
          If (mo_Db.GetFields(lc_CursorMaster, "OFD_SAPAct") = "D") Or (mo_Db.GetFields(lc_CursorMaster, "OFD_SAPAct") = "K") Then
              'DELETE GROUPS
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "LINE_GROUP", "")
                  
            Call CreateXMLNode("ACTION_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "ACTION_CODE"), lo_XMLDoc, lo_SubNode)
            Call CreateXMLNode("SAP_CANC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SAP_CANC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode)
          
          ElseIf mo_Db.GetFields(lc_CursorMaster, "OFD_SAPAct") = "A" Then
            'ADD GROUPS
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "LINE_GROUP", "")
                    
            Call CreateXMLNode("ACTION_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "ACTION_CODE"), lo_XMLDoc, lo_SubNode)
                
            Set lo_SubNode2 = AppendElement(lo_XMLDoc, lo_SubNode, "LINE_DETAIL_GROUP", "")
                
            Call CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MATERIAL_NO"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("EPC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "EPC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("FREE_OF_CHARGE_IND", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "FREE_OF_CHARGE_IND"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("MFG_PRE_RESERV_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MFG_PRE_RESERV_NO"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("MFG_PRE_RESERV_LIN_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MFG_PRE_RESERV_LIN_POS"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("CUST_POSITION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "CUST_POSITION"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("SALES_QTY_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_QTY_PCS"), lo_XMLDoc, lo_SubNode2)
              Call CreateXMLNode("SALES_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("SALES_QTY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_QTY"), lo_XMLDoc, lo_SubNode2)
              Call CreateXMLNode("SALES_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("LINE_PRICE_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_AMT_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("LINE_PRICE_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_AMT"), lo_XMLDoc, lo_SubNode2)
            End If
            Call CreateXMLNode("LINE_PRICE_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_CURR"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("LINE_PRICE_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UNIT"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("LINE_PRICE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("LINE_PRICE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            Call CreateXMLNode("SHIPPING_PLANT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SHIPPING_PLANT"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("ITM_REQ_DEL_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "ITM_REQ_DEL_DATE"), lo_XMLDoc, lo_SubNode2)
          
            ls_ATR_Value = GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_LINE")
            
            If Len(ls_ATR_Value) > 0 Then
                Set lo_SubNode3 = AppendElement(lo_XMLDoc, lo_SubNode2, "ITM_TEXTS", "")
                    
                Set lo_SubNode4 = AppendElement(lo_XMLDoc, lo_SubNode3, "ITM_TEXT_GROUP", "")
                
                Call CreateXMLNode("TEXT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_ID"), lo_XMLDoc, lo_SubNode4)
                Call CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_LANGU"), lo_XMLDoc, lo_SubNode4)
            
                Set lo_SubNode5 = AppendElement(lo_XMLDoc, lo_SubNode4, "TEXT_LINES", "")
              
                ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                
                la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
                
                For ll_Index = 0 To UBound(la_StrValues)
                    Call CreateXMLNode("TEXT_LINE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubNode5)
                Next
            End If
    
          ElseIf mo_Db.GetFields(lc_CursorMaster, "OFD_SAPAct") = "R" Then
  'REPLACE GROUPS
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "LINE_GROUP", "")
                    
            Call CreateXMLNode("ACTION_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "ACTION_CODE"), lo_XMLDoc, lo_SubNode)
            Call CreateXMLNode("SAP_CANC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SAP_CANC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode)
                
            Set lo_SubNode2 = AppendElement(lo_XMLDoc, lo_SubNode, "LINE_DETAIL_GROUP", "")
                
            Call CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MATERIAL_NO"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("EPC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "EPC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("FREE_OF_CHARGE_IND", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "FREE_OF_CHARGE_IND"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("MFG_PRE_RESERV_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MFG_PRE_RESERV_NO"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("MFG_PRE_RESERV_LIN_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MFG_PRE_RESERV_LIN_POS"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("CUST_POSITION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "CUST_POSITION"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("SALES_QTY_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_QTY_PCS"), lo_XMLDoc, lo_SubNode2)
              Call CreateXMLNode("SALES_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("SALES_QTY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_QTY"), lo_XMLDoc, lo_SubNode2)
              Call CreateXMLNode("SALES_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("LINE_PRICE_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_AMT_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("LINE_PRICE_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_AMT"), lo_XMLDoc, lo_SubNode2)
            End If
            Call CreateXMLNode("LINE_PRICE_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_CURR"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("LINE_PRICE_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UNIT"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("LINE_PRICE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("LINE_PRICE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            Call CreateXMLNode("SHIPPING_PLANT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SHIPPING_PLANT"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("ITM_REQ_DEL_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "ITM_REQ_DEL_DATE"), lo_XMLDoc, lo_SubNode2)
          
            ls_ATR_Value = GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_LINE")
            ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
            
            If Len(ls_ATR_Value) > 0 Then
              Set lo_SubNode3 = AppendElement(lo_XMLDoc, lo_SubNode2, "ITM_TEXTS", "")
            
              Set lo_SubNode4 = AppendElement(lo_XMLDoc, lo_SubNode3, "ITM_TEXT_GROUP", "")
              
              Call CreateXMLNode("TEXT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_ID"), lo_XMLDoc, lo_SubNode4)
              Call CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_LANGU"), lo_XMLDoc, lo_SubNode4)
              
              Set lo_SubNode5 = AppendElement(lo_XMLDoc, lo_SubNode4, "TEXT_LINES", "")
                                    
              la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
                  
              For ll_Index = 0 To UBound(la_StrValues)
                  Call CreateXMLNode("TEXT_LINE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubNode5)
              Next
            End If
            
          End If
        
          Call mo_Db.Next(lc_CursorMaster)
          
      Wend
   End If
          
  mo_Db.Close (lc_CursorMaster)
  
  mo_Db.Close (lc_CursorXML)
  
  Set lo_SubNode2 = Nothing
  Set lo_SubNode = Nothing
  Set lo_ParentNode = Nothing
  Set lo_MainNode = Nothing
  
#If LIVE = 0 Then
  SalesOrderLineCancelAddReplaceGetXML = SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderLineCancelAddReplace", "SAPAMCSalesOrderChange", False)
  Exit Function
#Else
  SalesOrderLineCancelAddReplaceGetXML = SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderLineCancelAddReplace", "SAPAMCSalesOrderChange")
  
#End If
  
  Exit Function
ErrorHandler:
  
  If lc_CursorMaster <> 0 Then
    mo_Db.Close (lc_CursorMaster)
  End If
  
  If lc_CursorXML <> 0 Then
    mo_Db.Close (lc_CursorXML)
  End If

  Set lo_SubNode2 = Nothing
  Set lo_SubNode = Nothing
  Set lo_ParentNode = Nothing
  Set lo_MainNode = Nothing

  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)

  Call ErrorHandler("SalesOrderLineCancelAddReplaceGetXML")
End Function

Public Function SalesOrderLineCancelAddReplace_v2(ByVal as_COF_Id As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrorHandler

Dim ls_Filename As String
Dim ls_Response As String

        SalesOrderLineCancelAddReplace_v2 = False
        
        ls_Filename = SalesOrderLineCancelAddReplaceGetXML_v2(as_COF_Id)
        
        Call TransferXMLDocument(App.Path & "\" & ls_Filename, as_ErrorMsg)
        
        'If (SendRequest(DPC_SAP_SALESORDER_CHANGE, "POST", ls_Xml, ls_Response) = True) Then
        '
        '    If (SalesOrderCreateProcessResponse(ls_Response, as_ErrorMsg) = True) Then
        '        SalesOrderLineCancelAddReplace = True
        '    End If
        '
        '    Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
        'Else
        '    as_ErrorMsg = ls_Response
        'End If
        
  Exit Function
ErrorHandler:
  
  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)

  Call ErrorHandler("SalesOrderLineCancelAddReplace_v2")
End Function

Public Function SalesOrderLineCancelAddReplaceGetXML_v2(ByVal as_COF_Id As String) As String
On Error GoTo ErrorHandler

Dim lo_XmlDocCust As Object
'Dim ll_Version As Long
Dim lo_SubNode1 As Object, lo_SubNode2 As Object, lo_SubNode3 As Object, lo_SubNode4 As Object, lo_SubNode5 As Object
Dim lo_ParentNode As Object, lo_SubNode As Object
Dim lo_MainNode As Object
Dim lc_CursorMaster As Long
Dim lc_CursorXML As Long
Dim lc_CursorGroup As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ls_Request As String
Dim ls_ATR_Value As String
Dim ls_ATR_DataLength As Long
Dim la_StrValues() As String
Dim ll_Index As Integer
Dim ls_UOM As String
Dim le_CAT_Id As eDPCCategory
Dim ls_Filename As String

On Error GoTo ErrorHandler
  
  Call mo_Tools.ClearLogInterface(Me)
  ILO_Interface = eDPCXmlExportType.etAMC_SalesOrderLineCancelAddReplace
  ILO_MasterId = as_COF_Id
  
  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  
  lc_CursorXML = GetXmlCursor(eDPCXmlExportType.etAMC_SalesOrderLineCancelAddReplace_v2)
    
  Set lo_MainNode = lo_XMLDoc.createProcessingInstruction("xml", "version='1.0' encoding='utf-8'")
  lo_XMLDoc.appendChild lo_MainNode
    
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "AMC_SALES_ORD_LINE_CANCEL_ADD_REPLACE", "")
  lo_MainNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
      
  ls_Request = "exec DPC_SAPSalesOrderLineChangeHeader_sel $COF_Id$,$Language_Code$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$Language_Code$", "'E'", , , vbTextCompare)
  lc_CursorMaster = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  
  Call mo_Db.First(lc_CursorMaster)
        
  Call CreateXMLNode("SAP_ORD_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SAP_ORD_NO"), lo_XMLDoc, lo_MainNode)
  Call CreateXMLNode("EPC_ORD_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "EPC_ORD_NO"), lo_XMLDoc, lo_MainNode)
                
  mo_Db.Close (lc_CursorMaster)

  'LINES
  ls_Request = "exec DPC_SAPSalesOrderLineChangeLines_lst $COF_Id$,'E'"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  lc_CursorMaster = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    
  If mo_Db.RowCount(lc_CursorMaster) > 0 Then
      
      Set lo_ParentNode = AppendElement(lo_XMLDoc, lo_MainNode, "LINES", "")
      
      Call mo_Db.First(lc_CursorMaster)
      
      While Not mo_Db.EOF(lc_CursorMaster)
                
          ls_UOM = GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_UOM")
          le_CAT_Id = mo_Db.GetFields(lc_CursorMaster, "CAT_Id")
          
          If mo_Db.GetFields(lc_CursorMaster, "OFD_SAPAct") = "D" Then
              'DELETE GROUPS
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "LINE_GROUP", "")
                  
            Call CreateXMLNode("ACTION_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "ACTION_CODE"), lo_XMLDoc, lo_SubNode)
            Call CreateXMLNode("SAP_CANC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SAP_CANC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode)
          
          ElseIf mo_Db.GetFields(lc_CursorMaster, "OFD_SAPAct") = "A" Then
            'ADD GROUPS
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "LINE_GROUP", "")
                    
            Call CreateXMLNode("ACTION_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "ACTION_CODE"), lo_XMLDoc, lo_SubNode)
                
            Set lo_SubNode2 = AppendElement(lo_XMLDoc, lo_SubNode, "LINE_DETAIL_GROUP", "")
                
            Call CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MATERIAL_NO"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("EPC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "EPC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("FREE_OF_CHARGE_IND", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "FREE_OF_CHARGE_IND"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("MFG_PRE_RESERV_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MFG_PRE_RESERV_NO"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("MFG_PRE_RESERV_LIN_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MFG_PRE_RESERV_LIN_POS"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("CUST_POSITION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "CUST_POSITION"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("SALES_QTY_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_QTY_PCS"), lo_XMLDoc, lo_SubNode2)
              Call CreateXMLNode("SALES_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("SALES_QTY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_QTY"), lo_XMLDoc, lo_SubNode2)
              Call CreateXMLNode("SALES_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("LINE_PRICE_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_AMT_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("LINE_PRICE_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_AMT"), lo_XMLDoc, lo_SubNode2)
            End If
            Call CreateXMLNode("LINE_PRICE_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_CURR"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("LINE_PRICE_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UNIT"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("LINE_PRICE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("LINE_PRICE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            Call CreateXMLNode("SHIPPING_PLANT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SHIPPING_PLANT"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("ITM_REQ_DEL_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "ITM_REQ_DEL_DATE"), lo_XMLDoc, lo_SubNode2)
          
            ls_ATR_Value = GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_LINE")
            
            If Len(ls_ATR_Value) > 0 Then
                Set lo_SubNode3 = AppendElement(lo_XMLDoc, lo_SubNode2, "ITM_TEXTS", "")
                    
                Set lo_SubNode4 = AppendElement(lo_XMLDoc, lo_SubNode3, "ITM_TEXT_GROUP", "")
                
                Call CreateXMLNode("TEXT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_ID"), lo_XMLDoc, lo_SubNode4)
                Call CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_LANGU"), lo_XMLDoc, lo_SubNode4)
            
                Set lo_SubNode5 = AppendElement(lo_XMLDoc, lo_SubNode4, "TEXT_LINES", "")
              
                ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                
                la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
                
                For ll_Index = 0 To UBound(la_StrValues)
                    Call CreateXMLNode("TEXT_LINE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubNode5)
                Next
            End If
    
          ElseIf mo_Db.GetFields(lc_CursorMaster, "OFD_SAPAct") = "R" Then
  'REPLACE GROUPS
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_ParentNode, "LINE_GROUP", "")
                    
            Call CreateXMLNode("ACTION_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "ACTION_CODE"), lo_XMLDoc, lo_SubNode)
            Call CreateXMLNode("SAP_CANC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SAP_CANC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode)
                
            Set lo_SubNode2 = AppendElement(lo_XMLDoc, lo_SubNode, "LINE_DETAIL_GROUP", "")
                
            Call CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MATERIAL_NO"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("EPC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "EPC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("FREE_OF_CHARGE_IND", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "FREE_OF_CHARGE_IND"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("MFG_PRE_RESERV_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MFG_PRE_RESERV_NO"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("MFG_PRE_RESERV_LIN_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MFG_PRE_RESERV_LIN_POS"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("CUST_POSITION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "CUST_POSITION"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("SALES_QTY_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_QTY_PCS"), lo_XMLDoc, lo_SubNode2)
              Call CreateXMLNode("SALES_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("SALES_QTY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_QTY"), lo_XMLDoc, lo_SubNode2)
              Call CreateXMLNode("SALES_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SALES_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("LINE_PRICE_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_AMT_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("LINE_PRICE_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_AMT"), lo_XMLDoc, lo_SubNode2)
            End If
            Call CreateXMLNode("LINE_PRICE_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_CURR"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("LINE_PRICE_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UNIT"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call CreateXMLNode("LINE_PRICE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call CreateXMLNode("LINE_PRICE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "LINE_PRICE_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            Call CreateXMLNode("SHIPPING_PLANT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "SHIPPING_PLANT"), lo_XMLDoc, lo_SubNode2)
            Call CreateXMLNode("ITM_REQ_DEL_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "ITM_REQ_DEL_DATE"), lo_XMLDoc, lo_SubNode2)
          
            ls_ATR_Value = GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_LINE")
            ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
            
            If Len(ls_ATR_Value) > 0 Then
              Set lo_SubNode3 = AppendElement(lo_XMLDoc, lo_SubNode2, "ITM_TEXTS", "")
            
              Set lo_SubNode4 = AppendElement(lo_XMLDoc, lo_SubNode3, "ITM_TEXT_GROUP", "")
              
              Call CreateXMLNode("TEXT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_ID"), lo_XMLDoc, lo_SubNode4)
              Call CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "TEXT_LANGU"), lo_XMLDoc, lo_SubNode4)
              
              Set lo_SubNode5 = AppendElement(lo_XMLDoc, lo_SubNode4, "TEXT_LINES", "")
                                    
              la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
                  
              For ll_Index = 0 To UBound(la_StrValues)
                  Call CreateXMLNode("TEXT_LINE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubNode5)
              Next
            End If
            
          End If
        
          Call mo_Db.Next(lc_CursorMaster)
          
      Wend
   End If
          
          
  ls_Filename = mo_Db.GeFields(lc_CursorMaster, "COF_Code") & "-" & Format(Now, "yyyymmdd") & ".XML"
  mo_Db.Close (lc_CursorMaster)
  
  mo_Db.Close (lc_CursorXML)
  
  Set lo_SubNode2 = Nothing
  Set lo_SubNode = Nothing
  Set lo_ParentNode = Nothing
  Set lo_MainNode = Nothing
  
  Call SaveXMLDocument(lo_XMLDoc, ls_Filename, "SAPAMCSalesOrderChange", False)
  SalesOrderLineCancelAddReplaceGetXML_v2 = ls_Filename
'#If LIVE = 0 Then
'  SalesOrderLineCancelAddReplaceGetXML_v2 = SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderLineCancelAddReplace", "SAPAMCSalesOrderChange", False)
'  Exit Function
'#Else
'  SalesOrderLineCancelAddReplaceGetXML_v2 = SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderLineCancelAddReplace", "SAPAMCSalesOrderChange")
'#End If
  
  Exit Function
ErrorHandler:
  
  If lc_CursorMaster <> 0 Then
    mo_Db.Close (lc_CursorMaster)
  End If
  
  If lc_CursorXML <> 0 Then
    mo_Db.Close (lc_CursorXML)
  End If

  Set lo_SubNode2 = Nothing
  Set lo_SubNode = Nothing
  Set lo_ParentNode = Nothing
  Set lo_MainNode = Nothing

  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)

  Call ErrorHandler("SalesOrderLineCancelAddReplaceGetXML")
End Function

Public Function SendRequest(ByVal as_RestAddress As String, ByVal as_Type As String, ByVal as_XML As String, ByRef as_Response As String) As Boolean
On Error GoTo ErrorHandler

#If LIVE = 1 Then
'    Dim mo_Sys As Object
    Dim mo_XMLHttp As Object
#Else
'    Dim mo_Sys As ARMSYSCOMLib.ArmSYS
    Dim mo_XMLHttp As Object
#End If
    
    Dim ld_RequestTime As Date
    Dim lb_SendOk As Boolean
    
    ld_RequestTime = Now()
    SendRequest = False
    lb_SendOk = False
    
    ILO_XMLSent = as_XML
    
    Set mo_XMLHttp = CreateObject("MSXML2.ServerXMLHTTP")
    
    Call mo_XMLHttp.setTimeouts(40000, 40000, 40000, 40000)
    
    'since the server i am communicating with is using a self signed certificate authority
    ' I have to ignore all ssl errors.
    'XMLHTTP.setOption 2, 13056
    
    ' I set the friendlyname of my certificate just in case i have tried with and without
    'XMLHTTP.setOption 3, "myrealfriendlynameofcrt"
    
    If as_Type = "GET" Then
        
        ILO_Connection = "http://lccas050.americas.armstrong.com:6010/" & as_RestAddress & "?AwiApiKey=vfls9eviwzyEbgIudODJfBlQef0JCXULQ+FfuaZHZf4=&SourceSystem=Capture&SchemaVersion=1.0&ClientIdentifier=FooBar"
        Call mo_XMLHttp.Open("GET", "http://lccas050.americas.armstrong.com:6010/" & as_RestAddress & "?AwiApiKey=vfls9eviwzyEbgIudODJfBlQef0JCXULQ+FfuaZHZf4=&SourceSystem=Capture&SchemaVersion=1.0&ClientIdentifier=FooBar", False)
        
        On Error Resume Next
        Call mo_XMLHttp.send
            
    ElseIf as_Type = "POST" Then
    
        ILO_Connection = "http://lccas050.americas.armstrong.com:6010/" & as_RestAddress
        Call mo_XMLHttp.Open("POST", "http://lccas050.americas.armstrong.com:6010/" & as_RestAddress, False)
        
        mo_XMLHttp.setRequestHeader "Content-type", "application/xml"
        mo_XMLHttp.setRequestHeader "x-awi-ApiKey", "vfls9eviwzyEbgIudODJfBlQef0JCXULQ+FfuaZHZf4="
        mo_XMLHttp.setRequestHeader "x-awi-SourceSystem", "Capture"
        mo_XMLHttp.setRequestHeader "x-awi-SchemaVersion", "1.0"
        
        On Error Resume Next
        With mo_XMLHttp
         .send (as_XML)
        End With
    End If
    
    If Err.Number <> 0 Then
        as_Response = "Send error occured: " & Err.Description
        ILO_Error = Err.Description
        ILO_Status = eDPCInterfaceStatus.isFailed
        Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
    Else
        lb_SendOk = True
    End If
    
    On Error GoTo ErrorHandler
    
    ILO_Performance = DateDiff("s", ld_RequestTime, Now())
    
    If lb_SendOk = True Then
        If mo_XMLHttp.Status < 200 Or mo_XMLHttp.Status > 202 Then
            as_Response = "Error occured : " & mo_XMLHttp.Status & " - " & mo_XMLHttp.statusText
            ILO_Error = as_Response
            ILO_Status = eDPCInterfaceStatus.isFailed
            Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
        Else
            as_Response = mo_XMLHttp.responseText
            ILO_XMLResponse = as_Response
            ILO_RespMsg = as_Response
            SendRequest = True
        End If
    End If
    
    Set mo_XMLHttp = Nothing
    
    Exit Function
  
ErrorHandler:
  Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
  Call ErrorHandler("SendRequest")
End Function

Public Function TransferXMLDocument(ByVal as_FileName As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrorHandler

#If LIVE = 1 Then
    Dim lo_FTP As Object
    Set lo_FTP = CreateObject("ArmSysCOM.ArmFTP")
#Else
    Dim lo_FTP As ARMSYSCOMLib.ArmFTP
    Set lo_FTP = New ARMSYSCOMLib.ArmFTP
#End If

Dim ls_Error As String
Dim ls_FTPServerIP As String, ls_FTPServerLogin As String, ls_FTPServerPswd As String, ls_FTPServerPath As String
Dim ls_Bae_FTPConn() As String
    
    TransferXMLDocument = False
    
    ls_Bae_FTPConn = Split(mo_Tools.GetAConfigData("DPC_BAE_FTP_SLSORD"), SEP1)
    
    ls_FTPServerIP = ls_Bae_FTPConn(0)
    ls_FTPServerLogin = ls_Bae_FTPConn(1)
    ls_FTPServerPswd = ls_Bae_FTPConn(2)
    ls_FTPServerPath = ls_Bae_FTPConn(3)
    ls_Error = ""
    
    If OpenFTP(lo_FTP, ls_FTPServerIP, ls_FTPServerLogin, ls_FTPServerPswd, ls_Error) Then

        ' upload file to FTP server
        If UploadFile(lo_FTP, App.Path & "\" & as_FileName & ".xml", ls_FTPServerPath & as_FileName & ".xml", ls_Error) = True Then
            TransferXMLDocument = True
        End If
        
        Call lo_FTP.LogoffServer
    
    End If
          
    as_ErrorMsg = ls_Error
    
    Exit Function
ErrorHandler:
  Call ErrorHandler("TransferXMLDocument")
End Function


' ************************************************************************************
' ******************************* FTP FUNCTIONS **************************************
' ************************************************************************************
#If LIVE = 1 Then
Private Function OpenFTP(ByRef ao_FTP As Object, ByVal as_IP As String, as_Login As String, as_Password As String, ByRef as_ErrorMsg As String) As Boolean
#Else
Private Function OpenFTP(ByRef ao_FTP As ARMSYSCOMLib.ArmFTP, ByVal as_IP As String, as_Login As String, as_Password As String, ByRef as_ErrorMsg As String) As Boolean
#End If
On Error GoTo ErrHandler
    OpenFTP = False
    
    If Not ao_FTP.LogOnToServer(as_IP, , as_Login, as_Password) Then
        as_ErrorMsg = "Cannot connect to FTP Server: " & as_IP
        Exit Function
    End If
        
    Dim ll_i As Long
    ll_i = InStr(1, as_Login, "/")
    If ll_i <> 0 Then
        ms_FTPRoot = right(as_Login, Len(as_Login) - ll_i) & "\"
    Else
        ms_FTPRoot = ""
    End If

    OpenFTP = True
    Exit Function
ErrHandler:
    Call ErrorHandler("OpenFTP()")
End Function

#If LIVE = 1 Then
Private Function UploadFile(ByVal ao_FTP As Object, ByVal as_FileName As String, ByVal as_UploadedFile As String, ByRef as_ErrorMsg As String) As Boolean
#Else
Private Function UploadFile(ByVal ao_FTP As ARMSYSCOMLib.ArmFTP, ByVal as_FileName As String, ByVal as_UploadedFile As String, ByRef as_ErrorMsg As String) As Boolean
#End If
On Error GoTo ErrHandler
    Dim ll_BytesTransfered As Long
    Dim ll_BytesTotal As Long
    Dim ll_Result As Long
    
    UploadFile = False
           
    If Not ao_FTP.UploadFileAsynch(as_FileName, as_UploadedFile, FTP_PASIVE) Then
        as_ErrorMsg = "FTP file upload failed. File name:\\" & as_FileName
        Exit Function
    Else
        ' set global value
        ms_copyFile = as_FileName
        ' this consume most of the time of file upload
        While ao_FTP.AsynchOperationProgress(ll_BytesTransfered, ll_BytesTotal, ll_Result) And Not mb_copyAbort
            ll_Result = DoEvents()
            'call sleep()
            Debug.Print ll_BytesTransfered & " : " & ll_BytesTotal & " Result: " & ll_Result
        Wend
        Debug.Print ll_BytesTransfered & " : " & ll_BytesTotal & " Result: " & ll_Result
        
        If ll_BytesTransfered = ll_BytesTotal And Not mb_copyAbort And ll_Result <> 0 Then
                        
            ms_copyFile = ""
        Else
            ' transfer interrupted for some reason
            If mb_copyAbort Then
                ' stop download
                Call ao_FTP.AbortAsynch
                
                as_ErrorMsg = "FTP file upload aborted. File name:\\" & as_FileName
                Exit Function
            Else
                ' other FTP transfer abort
                
                as_ErrorMsg = "FTP file upload interupted. File name:\\" & as_FileName
                Exit Function
            End If
        End If
    End If
    
    UploadFile = True
    Exit Function
ErrHandler:
    Call ErrorHandler("UploadFile()")
End Function











